/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sk extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "greenwichsk\u00fd \u010das",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "acrejsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "acrejsk\u00fd letn\u00fd \u010das",
               "",
               "acrejsk\u00fd \u010das",
               "",
            };
        final String[] Apia = new String[] {
               "apijsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "apijsk\u00fd letn\u00fd \u010das",
               "",
               "apijsk\u00fd \u010das",
               "",
            };
        final String[] Cook = new String[] {
               "\u0161tandardn\u00fd \u010das Cookov\u00fdch ostrovov",
               "",
               "letn\u00fd \u010das Cookov\u00fdch ostrovov",
               "",
               "\u010das Cookov\u00fdch ostrovov",
               "",
            };
        final String[] Cuba = new String[] {
               "kub\u00e1nsky \u0161tandardn\u00fd \u010das",
               "CST",
               "kub\u00e1nsky letn\u00fd \u010das",
               "CDT",
               "kub\u00e1nsky \u010das",
               "CT",
            };
        final String[] Fiji = new String[] {
               "fid\u017eijsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "fid\u017eijsk\u00fd letn\u00fd \u010das",
               "",
               "fid\u017eijsk\u00fd \u010das",
               "",
            };
        final String[] Gulf = new String[] {
               "\u0161tandardn\u00fd \u010das Perzsk\u00e9ho z\u00e1livu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "chovdsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "chovdsk\u00fd letn\u00fd \u010das",
               "",
               "chovdsk\u00fd \u010das",
               "",
            };
        final String[] Iran = new String[] {
               "ir\u00e1nsky \u0161tandardn\u00fd \u010das",
               "",
               "ir\u00e1nsky letn\u00fd \u010das",
               "",
               "ir\u00e1nsky \u010das",
               "",
            };
        final String[] Niue = new String[] {
               "niuejsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "omsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "omsk\u00fd letn\u00fd \u010das",
               "",
               "omsk\u00fd \u010das",
               "",
            };
        final String[] Peru = new String[] {
               "peru\u00e1nsky \u0161tandardn\u00fd \u010das",
               "",
               "peru\u00e1nsky letn\u00fd \u010das",
               "",
               "peru\u00e1nsky \u010das",
               "",
            };
        final String[] Truk = new String[] {
               "chuuksk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "\u010das ostrova Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "\u010dilsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "\u010dilsk\u00fd letn\u00fd \u010das",
               "",
               "\u010dilsk\u00fd \u010das",
               "",
            };
        final String[] China = new String[] {
               "\u010d\u00ednsky \u0161tandardn\u00fd \u010das",
               "CST",
               "\u010d\u00ednsky letn\u00fd \u010das",
               "CDT",
               "\u010d\u00ednsky \u010das",
               "CT",
            };
        final String[] Cocos = new String[] {
               "\u010das Kokosov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "\u010das Davisovej stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "indick\u00fd \u010das",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "japonsk\u00fd \u0161tandardn\u00fd \u010das",
               "JST",
               "japonsk\u00fd letn\u00fd \u010das",
               "JDT",
               "japonsk\u00fd \u010das",
               "JT",
            };
        final String[] Korea = new String[] {
               "k\u00f3rejsk\u00fd \u0161tandardn\u00fd \u010das",
               "KST",
               "k\u00f3rejsk\u00fd letn\u00fd \u010das",
               "KST",
               "k\u00f3rejsk\u00fd \u010das",
               "KST",
            };
        final String[] Nauru = new String[] {
               "naurusk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "nep\u00e1lsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "palausk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "samojsk\u00fd \u0161tandardn\u00fd \u010das",
               "SST",
               "samojsk\u00fd letn\u00fd \u010das",
               "SST",
               "samojsk\u00fd \u010das",
               "SST",
            };
        final String[] Syowa = new String[] {
               "\u010das stanice \u0160\u00f3wa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "ton\u017esk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "ton\u017esk\u00fd letn\u00fd \u010das",
               "",
               "ton\u017esk\u00fd \u010das",
               "",
            };
        final String[] Yukon = new String[] {
               "yukonsk\u00fd \u010das",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "alja\u0161sk\u00fd \u0161tandardn\u00fd \u010das",
               "AKST",
               "alja\u0161sk\u00fd letn\u00fd \u010das",
               "AKDT",
               "alja\u0161sk\u00fd \u010das",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "amazonsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "amazonsk\u00fd letn\u00fd \u010das",
               "",
               "amazonsk\u00fd \u010das",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadyrsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "Anadyrsk\u00fd letn\u00fd \u010das",
               "",
               "Anadyrsk\u00fd \u010das",
               "",
            };
        final String[] Azores = new String[] {
               "azorsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "azorsk\u00fd letn\u00fd \u010das",
               "",
               "azorsk\u00fd \u010das",
               "",
            };
        final String[] Bhutan = new String[] {
               "bhut\u00e1nsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "brunejsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "\u0161tandardn\u00fd \u010das Ve\u013ekono\u010dn\u00e9ho ostrova",
               "",
               "letn\u00fd \u010das Ve\u013ekono\u010dn\u00e9ho ostrova",
               "",
               "\u010das Ve\u013ekono\u010dn\u00e9ho ostrova",
               "",
            };
        final String[] Guyana = new String[] {
               "guyansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "izraelsk\u00fd \u0161tandardn\u00fd \u010das",
               "IST",
               "izraelsk\u00fd letn\u00fd \u010das",
               "IDT",
               "izraelsk\u00fd \u010das",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "kosrajsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "\u010das Mawsonovej stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "moskovsk\u00fd \u0161tandardn\u00fd \u010das",
               "MSK",
               "moskovsk\u00fd letn\u00fd \u010das",
               "MSK",
               "moskovsk\u00fd \u010das",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "ponapsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samarsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "Samarsk\u00fd letn\u00fd \u010das",
               "",
               "Samarsk\u00fd \u010das",
               "",
            };
        final String[] Tahiti = new String[] {
               "tahitsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "tchajpejsk\u00fd \u0161tandardn\u00fd \u010das",
               "CST",
               "tchajpejsk\u00fd letn\u00fd \u010das",
               "CDT",
               "tchajpejsk\u00fd \u010das",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "tuvalsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "\u010das stanice Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "\u010das ostrovov Wallis a Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "arabsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "arabsk\u00fd letn\u00fd \u010das",
               "",
               "arabsk\u00fd \u010das",
               "",
            };
        final String[] Armenia = new String[] {
               "arm\u00e9nsky \u0161tandardn\u00fd \u010das",
               "",
               "arm\u00e9nsky letn\u00fd \u010das",
               "",
               "arm\u00e9nsky \u010das",
               "",
            };
        final String[] Bolivia = new String[] {
               "bol\u00edvijsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "chathamsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "chathamsk\u00fd letn\u00fd \u010das",
               "",
               "chathamsk\u00fd \u010das",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "koordinovan\u00fd svetov\u00fd \u010das",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ekv\u00e1dorsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "gambiersk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "gruz\u00ednsky \u0161tandardn\u00fd \u010das",
               "",
               "gruz\u00ednsky letn\u00fd \u010das",
               "",
               "gruz\u00ednsky \u010das",
               "",
            };
        final String[] Irkutsk = new String[] {
               "irkutsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "irkutsk\u00fd letn\u00fd \u010das",
               "",
               "irkutsk\u00fd \u010das",
               "",
            };
        final String[] Magadan = new String[] {
               "magadansk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "magadansk\u00fd letn\u00fd \u010das",
               "",
               "magadansk\u00fd \u010das",
               "",
            };
        final String[] Myanmar = new String[] {
               "mjanmarsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "norfolsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "norfolsk\u00fd letn\u00fd \u010das",
               "",
               "norfolsk\u00fd \u010das",
               "",
            };
        final String[] Noronha = new String[] {
               "\u0161tandardn\u00fd \u010das s\u00faostrovia Fernando de Noronha",
               "",
               "letn\u00fd \u010das s\u00faostrovia Fernando de Noronha",
               "",
               "\u010das s\u00faostrovia Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "r\u00e9unionsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "\u010das Rotherovej stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "\u010das \u0160alam\u00fanov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "tokelausk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "uruguajsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "uruguajsk\u00fd letn\u00fd \u010das",
               "",
               "uruguajsk\u00fd \u010das",
               "",
            };
        final String[] Vanuatu = new String[] {
               "vanuatsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "vanuatsk\u00fd letn\u00fd \u010das",
               "",
               "vanuatsk\u00fd \u010das",
               "",
            };
        final String[] Yakutsk = new String[] {
               "jakutsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "jakutsk\u00fd letn\u00fd \u010das",
               "",
               "jakutsk\u00fd \u010das",
               "",
            };
        final String[] Atlantic = new String[] {
               "atlantick\u00fd \u0161tandardn\u00fd \u010das",
               "AST",
               "atlantick\u00fd letn\u00fd \u010das",
               "AST",
               "atlantick\u00fd \u010das",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "braz\u00edlsky \u0161tandardn\u00fd \u010das",
               "",
               "braz\u00edlsky letn\u00fd \u010das",
               "",
               "braz\u00edlsky \u010das",
               "",
            };
        final String[] Chamorro = new String[] {
               "chamorrsk\u00fd \u010das",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "kolumbijsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "kolumbijsk\u00fd letn\u00fd \u010das",
               "",
               "kolumbijsk\u00fd \u010das",
               "",
            };
        final String[] Falkland = new String[] {
               "falklandsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "falklandsk\u00fd letn\u00fd \u010das",
               "",
               "falklandsk\u00fd \u010das",
               "",
            };
        final String[] Malaysia = new String[] {
               "malajzijsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "maldivsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ulanb\u00e1tarsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "ulanb\u00e1tarsk\u00fd letn\u00fd \u010das",
               "",
               "ulanb\u00e1tarsk\u00fd \u010das",
               "",
            };
        final String[] Pakistan = new String[] {
               "pakistansk\u00fd \u0161tandardn\u00fd \u010das",
               "PKT",
               "pakistansk\u00fd letn\u00fd \u010das",
               "PKST",
               "pakistansk\u00fd \u010das",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "paraguajsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "paraguajsk\u00fd letn\u00fd \u010das",
               "",
               "paraguajsk\u00fd \u010das",
               "",
            };
        final String[] Pitcairn = new String[] {
               "\u010das Pitcairnov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "sachalinsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "sachalinsk\u00fd letn\u00fd \u010das",
               "",
               "sachalinsk\u00fd \u010das",
               "",
            };
        final String[] Suriname = new String[] {
               "surinamsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "argent\u00ednsky \u0161tandardn\u00fd \u010das",
               "",
               "argent\u00ednsky letn\u00fd \u010das",
               "",
               "argent\u00ednsky \u010das",
               "",
            };
        final String[] Christmas = new String[] {
               "\u010das Viano\u010dn\u00e9ho ostrova",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "galap\u00e1gsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "hongkonsk\u00fd \u0161tandardn\u00fd \u010das",
               "HKT",
               "hongkonsk\u00fd letn\u00fd \u010das",
               "HKST",
               "hongkonsk\u00fd \u010das",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "indo\u010d\u00ednsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kam\u010datsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "Petropavlovsk-Kam\u010datskijsk\u00fd letn\u00fd \u010das",
               "",
               "Petropavlovsk-Kam\u010datsk\u00fd \u010das",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "kirgizsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "\u0161tandardn\u00fd \u010das ostrova lorda Howa",
               "",
               "letn\u00fd \u010das ostrova lorda Howa",
               "",
               "\u010das ostrova lorda Howa",
               "",
            };
        final String[] Marquesas = new String[] {
               "mark\u00e9zsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "maur\u00edcijsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "maur\u00edcijsk\u00fd letn\u00fd \u010das",
               "",
               "maur\u00edcijsk\u00fd \u010das",
               "",
            };
        final String[] Singapore = new String[] {
               "singapursk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "venezuelsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "volgogradsk\u00fd \u0161tandardn\u00fd \u010das",
               "MSK",
               "volgogradsk\u00fd letn\u00fd \u010das",
               "MSK",
               "volgogradsk\u00fd \u010das",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "azerbajd\u017eansk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "azerbajd\u017eansk\u00fd letn\u00fd \u010das",
               "",
               "azerbajd\u017eansk\u00fd \u010das",
               "",
            };
        final String[] Bangladesh = new String[] {
               "banglad\u00e9\u0161sky \u0161tandardn\u00fd \u010das",
               "",
               "banglad\u00e9\u0161sky letn\u00fd \u010das",
               "",
               "banglad\u00e9\u0161sky \u010das",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "kapverdsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "kapverdsk\u00fd letn\u00fd \u010das",
               "",
               "kapverdsk\u00fd \u010das",
               "",
            };
        final String[] East_Timor = new String[] {
               "v\u00fdchodotimorsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "seychelsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "tad\u017eick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "uzbeck\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "uzbeck\u00fd letn\u00fd \u010das",
               "",
               "uzbeck\u00fd \u010das",
               "",
            };
        final String[] Afghanistan = new String[] {
               "afgansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "krasnojarsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "krasnojarsk\u00fd letn\u00fd \u010das",
               "",
               "krasnojarsk\u00fd \u010das",
               "",
            };
        final String[] New_Zealand = new String[] {
               "novoz\u00e9landsk\u00fd \u0161tandardn\u00fd \u010das",
               "NZST",
               "novoz\u00e9landsk\u00fd letn\u00fd \u010das",
               "NZDT",
               "novoz\u00e9landsk\u00fd \u010das",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "novosibirsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "novosibirsk\u00fd letn\u00fd \u010das",
               "",
               "novosibirsk\u00fd \u010das",
               "",
            };
        final String[] Philippines = new String[] {
               "filip\u00ednsky \u0161tandardn\u00fd \u010das",
               "PST",
               "filip\u00ednsky letn\u00fd \u010das",
               "PDT",
               "filip\u00ednsky \u010das",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "vladivostock\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "vladivostock\u00fd letn\u00fd \u010das",
               "",
               "vladivostock\u00fd \u010das",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "indickooce\u00e1nsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "\u010das Rovn\u00edkov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "newfoundlandsk\u00fd \u0161tandardn\u00fd \u010das",
               "NST",
               "newfoundlandsk\u00fd letn\u00fd \u010das",
               "NDT",
               "newfoundlandsk\u00fd \u010das",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "turkm\u00e9nsky \u0161tandardn\u00fd \u010das",
               "",
               "turkm\u00e9nsky letn\u00fd \u010das",
               "",
               "turkm\u00e9nsky \u010das",
               "",
            };
        final String[] French_Guiana = new String[] {
               "franc\u00fazskoguyansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "novokaled\u00f3nsky \u0161tandardn\u00fd \u010das",
               "",
               "novokaled\u00f3nsky letn\u00fd \u010das",
               "",
               "novokaled\u00f3nsky \u010das",
               "",
            };
        final String[] South_Georgia = new String[] {
               "\u010das Ju\u017enej Georgie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "jekaterinbursk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "jekaterinbursk\u00fd letn\u00fd \u010das",
               "",
               "jekaterinbursk\u00fd \u010das",
               "",
            };
        final String[] Africa_Central = new String[] {
               "stredoafrick\u00fd \u010das",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "v\u00fdchodoafrick\u00fd \u010das",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "z\u00e1padoafrick\u00fd \u0161tandardn\u00fd \u010das",
               "WAT",
               "z\u00e1padoafrick\u00fd letn\u00fd \u010das",
               "WAT",
               "z\u00e1padoafrick\u00fd \u010das",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "\u010das stanice Dumonta d\u2019Urvillea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "stredoeur\u00f3psky \u0161tandardn\u00fd \u010das",
               "SE\u010c",
               "stredoeur\u00f3psky letn\u00fd \u010das",
               "SEL\u010c",
               "stredoeur\u00f3psky \u010das",
               "SE\u010c",
            };
        final String[] Europe_Eastern = new String[] {
               "v\u00fdchodoeur\u00f3psky \u0161tandardn\u00fd \u010das",
               "EET",
               "v\u00fdchodoeur\u00f3psky letn\u00fd \u010das",
               "EEST",
               "v\u00fdchodoeur\u00f3psky \u010das",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "z\u00e1padoeur\u00f3psky \u0161tandardn\u00fd \u010das",
               "WET",
               "z\u00e1padoeur\u00f3psky letn\u00fd \u010das",
               "WEST",
               "z\u00e1padoeur\u00f3psky \u010das",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "mexick\u00fd tichomorsk\u00fd \u0161tandardn\u00fd \u010das",
               "MST",
               "mexick\u00fd tichomorsk\u00fd letn\u00fd \u010das",
               "MDT",
               "mexick\u00fd tichomorsk\u00fd \u010das",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "juhoafrick\u00fd \u010das",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "severoamerick\u00fd centr\u00e1lny \u0161tandardn\u00fd \u010das",
               "CST",
               "severoamerick\u00fd centr\u00e1lny letn\u00fd \u010das",
               "CDT",
               "severoamerick\u00fd centr\u00e1lny \u010das",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "severoamerick\u00fd v\u00fdchodn\u00fd \u0161tandardn\u00fd \u010das",
               "EST",
               "severoamerick\u00fd v\u00fdchodn\u00fd letn\u00fd \u010das",
               "EST",
               "severoamerick\u00fd v\u00fdchodn\u00fd \u010das",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "severoamerick\u00fd tichomorsk\u00fd \u0161tandardn\u00fd \u010das",
               "PST",
               "severoamerick\u00fd tichomorsk\u00fd letn\u00fd \u010das",
               "PDT",
               "severoamerick\u00fd tichomorsk\u00fd \u010das",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "\u010das Franc\u00fazskych ju\u017en\u00fdch a antarktick\u00fdch \u00fazem\u00ed",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u010das Gilbertov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "havajsko-aleutsk\u00fd \u0161tandardn\u00fd \u010das",
               "HST",
               "havajsko-aleutsk\u00fd letn\u00fd \u010das",
               "HDT",
               "havajsko-aleutsk\u00fd \u010das",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u010das F\u00e9nixov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "pierre-miquelonsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "pierre-miquelonsk\u00fd letn\u00fd \u010das",
               "",
               "pierre-miquelonsk\u00fd \u010das",
               "",
            };
        final String[] America_Mountain = new String[] {
               "severoamerick\u00fd horsk\u00fd \u0161tandardn\u00fd \u010das",
               "MST",
               "severoamerick\u00fd horsk\u00fd letn\u00fd \u010das",
               "MST",
               "severoamerick\u00fd horsk\u00fd \u010das",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "\u010das Marshallov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u010das Papuy-Novej Guiney",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "stredoaustr\u00e1lsky \u0161tandardn\u00fd \u010das",
               "ACST",
               "stredoaustr\u00e1lsky letn\u00fd \u010das",
               "ACDT",
               "stredoaustr\u00e1lsky \u010das",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "v\u00fdchodoaustr\u00e1lsky \u0161tandardn\u00fd \u010das",
               "AEST",
               "v\u00fdchodoaustr\u00e1lsky letn\u00fd \u010das",
               "AEDT",
               "v\u00fdchodoaustr\u00e1lsky \u010das",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "z\u00e1padoaustr\u00e1lsky \u0161tandardn\u00fd \u010das",
               "AWST",
               "z\u00e1padoaustr\u00e1lsky letn\u00fd \u010das",
               "AWDT",
               "z\u00e1padoaustr\u00e1lsky \u010das",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "stredoindon\u00e9zsky \u010das",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "v\u00fdchodoindon\u00e9zsky \u010das",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "z\u00e1padoindon\u00e9zsky \u010das",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Western = new String[] {
               "z\u00e1padokazachstansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "stredoz\u00e1padn\u00fd austr\u00e1lsky \u0161tandardn\u00fd \u010das",
               "",
               "stredoz\u00e1padn\u00fd austr\u00e1lsky letn\u00fd \u010das",
               "",
               "stredoz\u00e1padn\u00fd austr\u00e1lsky \u010das",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "havajsko-aleutsk\u00fd \u0161tandardn\u00fd \u010das",
                    "HST",
                    "havajsko-aleutsk\u00fd letn\u00fd \u010das",
                    "HDT",
                    "havajsko-aleutsk\u00fd \u010das",
                    "HST",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "greenwichsk\u00fd \u010das",
                    "GMT",
                    "britsk\u00fd letn\u00fd \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "koordinovan\u00fd svetov\u00fd \u010das",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "greenwichsk\u00fd \u010das",
                    "GMT",
                    "\u00edrsky \u0161tandardn\u00fd \u010das",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "koordinovan\u00fd svetov\u00fd \u010das",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "koordinovan\u00fd svetov\u00fd \u010das",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "greenwichsk\u00fd \u010das",
                    "GMT",
                    "britsk\u00fd letn\u00fd \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "koordinovan\u00fd svetov\u00fd \u010das",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii",
                new String[] {
                    "havajsko-aleutsk\u00fd \u0161tandardn\u00fd \u010das",
                    "HST",
                    "havajsko-aleutsk\u00fd letn\u00fd \u010das",
                    "HDT",
                    "havajsko-aleutsk\u00fd \u010das",
                    "HST",
                }
            },
            { "Universal",
                new String[] {
                    "koordinovan\u00fd svetov\u00fd \u010das",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Western },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Western },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "koordinovan\u00fd svetov\u00fd \u010das",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "greenwichsk\u00fd \u010das",
                    "GMT",
                    "\u00edrsky \u0161tandardn\u00fd \u010das",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "greenwichsk\u00fd \u010das",
                    "GMT",
                    "britsk\u00fd letn\u00fd \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "greenwichsk\u00fd \u010das",
                    "GMT",
                    "britsk\u00fd letn\u00fd \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10",
                new String[] {
                    "havajsko-aleutsk\u00fd \u0161tandardn\u00fd \u010das",
                    "HST",
                    "havajsko-aleutsk\u00fd letn\u00fd \u010das",
                    "HDT",
                    "havajsko-aleutsk\u00fd \u010das",
                    "HST",
                }
            },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "greenwichsk\u00fd \u010das",
                    "GMT",
                    "britsk\u00fd letn\u00fd \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "greenwichsk\u00fd \u010das",
                    "GMT",
                    "britsk\u00fd letn\u00fd \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston",
                new String[] {
                    "havajsko-aleutsk\u00fd \u0161tandardn\u00fd \u010das",
                    "HST",
                    "havajsko-aleutsk\u00fd letn\u00fd \u010das",
                    "HDT",
                    "havajsko-aleutsk\u00fd \u010das",
                    "HST",
                }
            },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "greenwichsk\u00fd \u010das",
                    "GMT",
                    "britsk\u00fd letn\u00fd \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Hovd", "Chovd" },
            { "timezone.excity.Asia/Oral", "Ura\u013esk" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amm\u00e1n" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "\u010cita" },
            { "timezone.excity.Asia/Dhaka", "Dh\u00e1ka" },
            { "timezone.excity.Asia/Dubai", "Dubaj" },
            { "timezone.excity.Asia/Kabul", "K\u00e1bul" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Soul" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Beirut", "Bejr\u00fat" },
            { "timezone.excity.Asia/Brunei", "Brunej" },
            { "timezone.excity.Asia/Kuwait", "Kuvajt" },
            { "timezone.excity.Asia/Muscat", "Maskat" },
            { "timezone.excity.Asia/Riyadh", "Rij\u00e1d" },
            { "timezone.excity.Asia/Saigon", "Ho\u010diminovo Mesto" },
            { "timezone.excity.Asia/Taipei", "Tchaj-pej" },
            { "timezone.excity.Asia/Tehran", "Teher\u00e1n" },
            { "timezone.excity.Asia/Urumqi", "Urum\u010di" },
            { "timezone.excity.Etc/Unknown", "nezn\u00e1me mesto" },
            { "timezone.excity.Europe/Kiev", "Kyjev" },
            { "timezone.excity.Europe/Rome", "R\u00edm" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "K\u00e1hira" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrajn" },
            { "timezone.excity.Asia/Bishkek", "Bi\u0161kek" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Karachi", "Kar\u00e1\u010di" },
            { "timezone.excity.Asia/Kuching", "Ku\u010ding" },
            { "timezone.excity.Asia/Nicosia", "Nik\u00f3zia" },
            { "timezone.excity.Asia/Rangoon", "Rang\u00fan" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Europe/Paris", "Par\u00ed\u017e" },
            { "timezone.excity.Indian/Cocos", "Kokosov\u00e9 ostrovy" },
            { "timezone.excity.Pacific/Fiji", "Fid\u017ei" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "timezone.excity.Asia/Ashgabat", "A\u0161chabad" },
            { "timezone.excity.Asia/Calcutta", "Kalkata" },
            { "timezone.excity.Asia/Damascus", "Damask" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0161anbe" },
            { "timezone.excity.Asia/Katmandu", "K\u00e1thmandu" },
            { "timezone.excity.Asia/Khandyga", "Chandyga" },
            { "timezone.excity.Asia/Qostanay", "Kostanaj" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "timezone.excity.Asia/Shanghai", "\u0160anghaj" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0161kent" },
            { "timezone.excity.Asia/Ust-Nera", "Us\u0165-Nera" },
            { "timezone.excity.Europe/Athens", "At\u00e9ny" },
            { "timezone.excity.Europe/Berlin", "Berl\u00edn" },
            { "timezone.excity.Europe/Lisbon", "Lisabon" },
            { "timezone.excity.Europe/London", "Lond\u00fdn" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Viede\u0148" },
            { "timezone.excity.Europe/Warsaw", "Var\u0161ava" },
            { "timezone.excity.Europe/Zagreb", "Z\u00e1hreb" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "timezone.excity.Indian/Comoro", "Komory" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Al\u017e\u00edr" },
            { "timezone.excity.Africa/Tripoli", "Tripolis" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cayman", "Kajmanie ostrovy" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Jerusalem", "Jeruzalem" },
            { "timezone.excity.Asia/Kamchatka", "Kam\u010datka" },
            { "timezone.excity.Asia/Pyongyang", "Pchjongjang" },
            { "timezone.excity.Asia/Qyzylorda", "Kyzylorda" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Asia/Vientiane", "Vientian" },
            { "timezone.excity.Europe/Vatican", "Vatik\u00e1n" },
            { "timezone.excity.Pacific/Easter", "Ve\u013ekono\u010dn\u00fd ostrov" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Africa/Djibouti", "D\u017eibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El-Aai\u00fan" },
            { "timezone.excity.Africa/Khartoum", "Chart\u00fam" },
            { "timezone.excity.Africa/Ndjamena", "N\u2019Djamena" },
            { "timezone.excity.Africa/Sao_Tome", "Sv\u00e4t\u00fd Tom\u00e1\u0161" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Jamaica", "Jamajka" },
            { "timezone.excity.Asia/Choibalsan", "\u010cojbalsan" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom P\u00e9nh" },
            { "timezone.excity.Atlantic/Azores", "Azory" },
            { "timezone.excity.Atlantic/Canary", "Kan\u00e1rske ostrovy" },
            { "timezone.excity.Atlantic/Faeroe", "Faersk\u00e9 ostrovy" },
            { "timezone.excity.Europe/Belgrade", "Belehrad" },
            { "timezone.excity.Europe/Brussels", "Brusel" },
            { "timezone.excity.Europe/Budapest", "Budape\u0161\u0165" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "timezone.excity.Europe/Chisinau", "Ki\u0161i\u0148ov" },
            { "timezone.excity.Indian/Maldives", "Maldivy" },
            { "timezone.excity.Africa/Mogadishu", "Mogadi\u0161o" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.America/St_Lucia", "Sv\u00e4t\u00e1 Lucia" },
            { "timezone.excity.Antarctica/Syowa", "\u0160\u00f3wa" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulanb\u00e1tar" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudy" },
            { "timezone.excity.Europe/Astrakhan", "Astrach\u00e1n" },
            { "timezone.excity.Europe/Bucharest", "Bukure\u0161\u0165" },
            { "timezone.excity.Europe/Gibraltar", "Gibralt\u00e1r" },
            { "timezone.excity.Europe/Ljubljana", "\u013dub\u013eana" },
            { "timezone.excity.Europe/Stockholm", "\u0160tokholm" },
            { "timezone.excity.Europe/Ulyanovsk", "U\u013ejanovsk" },
            { "timezone.excity.Indian/Christmas", "Viano\u010dn\u00fd ostrov" },
            { "timezone.excity.Indian/Kerguelen", "Kergueleny" },
            { "timezone.excity.Indian/Mauritius", "Maur\u00edcius" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.America/St_Thomas", "Sv. Tom\u00e1\u0161" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuzneck" },
            { "timezone.excity.Europe/Copenhagen", "Koda\u0148" },
            { "timezone.excity.Europe/Luxembourg", "Luxembursko" },
            { "timezone.excity.Europe/San_Marino", "San Mar\u00edno" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Galap\u00e1gy" },
            { "timezone.excity.Pacific/Marquesas", "Mark\u00e9zy" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.America/Costa_Rica", "Kostarika" },
            { "timezone.excity.America/Martinique", "Martinik" },
            { "timezone.excity.America/St_Vincent", "Sv. Vincent" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Atlantic/St_Helena", "Sv\u00e4t\u00e1 Helena" },
            { "timezone.excity.Europe/Isle_of_Man", "Ostrov Man" },
            { "timezone.excity.America/El_Salvador", "Salv\u00e1dor" },
            { "timezone.excity.America/Mexico_City", "M\u00e9xico" },
            { "timezone.excity.America/Puerto_Rico", "Portoriko" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kapverdy" },
            { "timezone.excity.America/St_Barthelemy", "Sv\u00e4t\u00fd Bartolomej" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "Ju\u017en\u00e1 Georgia" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Severn\u00e1 Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Severn\u00e1 Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Severn\u00e1 Dakota" },
        };
        return data;
    }
}
