/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_so extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Wakhtiga Giriinwij",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Wakhtiga Caadiga ah ee Acre",
               "",
               "Wakhtiga Kulka ee Acre",
               "",
               "Wakhtiga Acre",
               "",
            };
        final String[] Apia = new String[] {
               "Waqtiga Caadiga Ah ee Abiya",
               "",
               "Waqtiga Dharaarta ee Abiya",
               "",
               "Waqtiga Abiya",
               "",
            };
        final String[] Cook = new String[] {
               "Waqtiga Caadiga Ah ee Kuuk Aylaanis",
               "",
               "Waqtiga Nus Xagaaga ah ee Kuuk Aylaanis",
               "",
               "Waqtiga Kuuk Aylaanis",
               "",
            };
        final String[] Cuba = new String[] {
               "Waqtiga Caadiga Ah ee Kuuba",
               "CST",
               "Waqtiga Dharaarta ee Kuuba",
               "CDT",
               "Waqtiga Kuuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Waqtiga Caadiga Ah ee Fiji",
               "",
               "Waqtiga Xagaaga ee Fiji",
               "",
               "Waqtiga Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Waqtiga Gacanka",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Waqtiga Caadiga Ah ee Hofud",
               "",
               "Waqtiga Xagaaga ee Hofud",
               "",
               "Waqtiga Hofud",
               "",
            };
        final String[] Iran = new String[] {
               "Waqtiga Caadiga Ah ee Iiraan",
               "",
               "Waqtiga Dharaarta ee Iiraan",
               "",
               "Waqtiga Iiraan",
               "",
            };
        final String[] Niue = new String[] {
               "Waqtiga Niyuu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Waqtiga Caadiga Ah ee Omsk",
               "",
               "Waqtiga Xagaaga ee Omsk",
               "",
               "Waqtiga Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Waqtiga Caadiga Ah ee Beeru",
               "",
               "Waqtiga Xagaaga ee Beeru",
               "",
               "Waqtiga Beeru",
               "",
            };
        final String[] Truk = new String[] {
               "Waqtiga Juuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Waqtiga Wayk Iylaanis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Waqtiga Caadiga Ah ee Jili",
               "",
               "Waqtiga Xagaaga ee Jili",
               "",
               "Waqtiga Jili",
               "",
            };
        final String[] China = new String[] {
               "Waqtiga Caadiga Ah ee Shiinaha",
               "CST",
               "Waqtiga Dharaarta ee Shiinaha",
               "CDT",
               "Waqtiga Shiinaha",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Waqtiga Kokos Aylaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Waqtiga Dafis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Waqtiga Caadiga Ah ee Hindiya",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Waqtiga Caadiga Ah ee Jabaan",
               "JST",
               "Waqtiga Dharaarta ee Jabaan",
               "JDT",
               "Waqtiga Jabaan",
               "JT",
            };
        final String[] Korea = new String[] {
               "Waqtiga Caadiga Ah ee Kuuriya",
               "KST",
               "Waqtiga Dharaarta ee Kuuriya",
               "KST",
               "Waqtiga Kuuriya",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Waqtiga Nawroo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Waqtiga Neebaal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Waqtiga Balaw",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Waqtiga Caadiga Ah ee Samoa",
               "SST",
               "Waqtiga Dharaarta ee Samoa",
               "SST",
               "Waqtiga Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Waqtiga Siyowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Waqtiga Caadiga Ah ee Tonga",
               "",
               "Waqtiga Xagaaga ee Tonga",
               "",
               "Waqtiga Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Waqtiga Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Waqtiga Caadiga Ah ee Alaska",
               "AKST",
               "Waqtiga Dharaarta ee Alaska",
               "AKDT",
               "Waqtiga Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Waqtiga Caadiga Ah ee Amason",
               "",
               "Waqtiga Xagaaga ee Amason",
               "",
               "Waqtiga Amason",
               "",
            };
        final String[] Anadyr = new String[] {
               "Wakhtiga Caadiga ah ee Anadyr",
               "",
               "Wakhtiga Kulka ee Anadyr",
               "",
               "Wakhtiga Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Waqtiga Caadiga Ah ee Asores",
               "",
               "Waqtiga Xagaaga ee Asores",
               "",
               "Waqtiga Asores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Waqtiga Butaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Waqtiga Buruney Daarusalaam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Waqtiga Caadiga Ah ee Iistar Aylaan",
               "",
               "Waqtiga Xagaaga ee Iistar Aylaan",
               "",
               "Waqtiga Iistar Aylaan",
               "",
            };
        final String[] Guyana = new String[] {
               "Waqtiga Guyaana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Waqtiga Caadiga Ah ee Israaiil",
               "IST",
               "Waqtiga Dharaarta ee Israaiil",
               "IDT",
               "Waqtiga Israaiil",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Waqtiga Kosriy",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Waqtiga Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Waqtiga Caadiga Ah ee Moskow",
               "MSK",
               "Waqtiga Xagaaga ee Moskow",
               "MSK",
               "Waqtiga Moskow",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Waqtiga Bonabe",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Wakhtiga Caadiga ah ee Samara",
               "",
               "Wakhtiga Kulka ee Samara",
               "",
               "Wakhtiga Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Waqtiga Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Waqtiga Caadiga Ah ee Teybey",
               "CST",
               "Waqtiga Dharaarta ee Teybey",
               "CDT",
               "Waqtiga Teybey",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Waqtiga Tufalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Waqtiga Fostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Waqtiga Walis & Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Waqtiga Caadiga Ah ee Carabta",
               "",
               "Waqtiga Dharaarta ee Carabta",
               "",
               "Waqtiga Carabta",
               "",
            };
        final String[] Armenia = new String[] {
               "Waqtiga Caadiga Ah ee Armeeniya",
               "",
               "Waqtiga Xagaaga ee Armeeniya",
               "",
               "Waqtiga Armeeniya",
               "",
            };
        final String[] Bolivia = new String[] {
               "Waqtiga Boliifiya",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Waqtiga Caadiga Ah ee Jaatam",
               "",
               "Waqtiga Dharaarta ee Jaatam",
               "",
               "Waqtiga Jaatam",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Waqtiga Isku-xiran ee Caalamka",
               "Waqtiga UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Waqtiga Ekuwadoor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Waqtiga Gambiyar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Waqtiga Caadiga Ah ee Joorjiya",
               "",
               "Waqtiga Xagaaga ee Joorjiya",
               "",
               "Waqtiga Joorjiya",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Waqtiga Caadiga Ah ee Irkutsik",
               "",
               "Waqtiga Xagaaga ee Irkutsik",
               "",
               "Waqtiga Irkutsik",
               "",
            };
        final String[] Magadan = new String[] {
               "Waqtiga Caadiga Ah ee Magedan",
               "",
               "Waqtiga Xagaaga ee Magedan",
               "",
               "Watiga Magedan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Waqtiga Mayanmaar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Waqtiga Caadiga ah ee Norfolk Island",
               "",
               "Waqtiga Maalinta ee Norfolk Island",
               "",
               "Waqtiga Norfolk Island",
               "",
            };
        final String[] Noronha = new String[] {
               "Waqtiga Caadiga Ah ee Farnaando de Nooronha",
               "",
               "Waqtiga Xagaaga ee Farnaando de Nooronha",
               "",
               "Waqtiga Farnaando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Waqtiga Riyuuniyon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Waqtiga Rotera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Waqtiga Solomon Aylaanis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Waqtiga Tokeluu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Waqtiga Caadiga Ah ee Urugwaay",
               "",
               "Waqtiga Xagaaga ee Urugwaay",
               "",
               "Waqtiga Urugwaay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Waqtiga Caadiga Ah ee Fanuutu",
               "",
               "Waqtiga Xagaaga ee Fanuutu",
               "",
               "Waqtiga Fanuutu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Waqtiga Caadiga Ah ee Yakut",
               "",
               "Waqtiga Xagaaga ee Yakut",
               "",
               "Waqtiyada Yakut",
               "",
            };
        final String[] Atlantic = new String[] {
               "Waqtiga Caadiga Ah ee Atlantika Waqooyiga Ameerika",
               "AST",
               "Waqtiga Dharaarta ee Atlantika Waqooyiga Ameerika",
               "AST",
               "Waqtiga Atlantika ee Waqooyiga Ameerika",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Waqtiga Caadiga ah ee Baraasiliya",
               "",
               "Waqtiga Xagaaga ee Baraasiliya",
               "",
               "Waqtiga Baraasiliya",
               "",
            };
        final String[] Chamorro = new String[] {
               "Waqtiga Jamoro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Waqtiga Caadiga Ah ee Kolambiya",
               "",
               "Waqtiga Xagaaga ee Kolambiya",
               "",
               "Waqtiga Kolambiya",
               "",
            };
        final String[] Falkland = new String[] {
               "Waqtiga Caadiga Ah ee Faalklaan Aylaanis",
               "",
               "Waqtiga Xagaaga ee Faalklaan Aylaanis",
               "",
               "Waqtiga Faalklaan Aylaanis",
               "",
            };
        final String[] Malaysia = new String[] {
               "Waqtiga Maleyshiya",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Waqtiga Maldifis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Waqtiga Caadiga Ah ee Ulaanbaataar",
               "",
               "Waqtiga Xagaaga ee Ulaanbaataar",
               "",
               "Waqtiga Ulaanbaataar",
               "",
            };
        final String[] Pakistan = new String[] {
               "Waqtiga Caadiga Ah ee Bakistaan",
               "PKT",
               "Waqtiga Xagaaga ee Bakistaan",
               "PKST",
               "Waqtiga Bakistaan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Waqtiga Caadiga Ah ee Baragwaay",
               "",
               "Waqtiga Xagaaga ee Baragwaay",
               "",
               "Waqtiga Baragwaay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Waqtiga Bitkeen",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Waqtiga Caadiga Ah ee Sakhalin",
               "",
               "Waqtiga Xagaaga ee Sakhalin",
               "",
               "Waqtiga Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Waqtiga Surineym",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Waqtiga Caadiga Ah ee Arjentiina",
               "",
               "Waqtiga Xagaaga ee Arjentiina",
               "",
               "Waqtia Arjentiina",
               "",
            };
        final String[] Christmas = new String[] {
               "Waqtiga Kirismas Aylaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Waqtiga Galabagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Waqtiga Caadiga Ah ee Hoong Koong",
               "HKT",
               "Waqtiga Xagaaga ee Hoong Koong",
               "HKST",
               "Waqtiga Hoong Koong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Waqtiga Indoshiina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Wakhtiga Caadiga ah ee Petropavlovsk-Kamchatski",
               "",
               "Wakhtiga Kulka ee Petropavlovsk-Kamchatski",
               "",
               "Wakhtiga Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Waqtiga Kiyrigistaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Waqtiga Caadiga Ah ee Lod How",
               "",
               "Waqtiga Dharaarta ee Lod How",
               "",
               "Waqtiga Lod How",
               "",
            };
        final String[] Marquesas = new String[] {
               "Waqtiga Marquwesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Waqtiga Caadiga Ah ee Morishiyaas",
               "",
               "Waqtiga Xagaaga ee Morishiyaas",
               "",
               "Waqtiga Morishiyaas",
               "",
            };
        final String[] Singapore = new String[] {
               "Waqtiga Singabuur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Waqtiga Fenezuweela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Waqtiga Caadiga Ah ee Folgograd",
               "MSK",
               "Waqtiga Xagaaga ee Folgograd",
               "MSK",
               "Waqtiga Folgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Waqtiga Caadiga Ah ee Asarbeyjan",
               "",
               "Waqtiga Xagaaga ee Asarbeyjan",
               "",
               "Waqtiga Asarbeyjan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Waqtiga Caadiga Ah ee Bangledeesh",
               "",
               "Waqtiga Xagaaga ee Bangledeesh",
               "",
               "Waqtiga Bangledeesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Waqtiga Caadiga Ah ee Keyb Faarde",
               "",
               "Waqtiga Xagaaga ee Keyb Faarde",
               "",
               "Waqtiga Keyb Faarde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Waqtiga Iist Timoor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Waqtiga Siishalis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Waqtiga Tajikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Waqtiga Caadiga Ah ee Usbekistan",
               "",
               "Waqtiga Xagaaga ee Usbekistan",
               "",
               "Waqtiga Usbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Waqtiga Afggaanistaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Waqtiga Caadiga Ah ee Karasnoyarsik",
               "",
               "Waqtiga Xagaaga ee Karasnoyarsik",
               "",
               "Waqtiga Karasnoyarsik",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Waqtiga Caadiga Ah ee Niyuu Si\u2019laan",
               "NZST",
               "Waqtiga Dharaarta ee Niyuu Si\u2019laan",
               "NZDT",
               "Waqtiga Niyuu Si\u2019laan",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Waqtiga Caadiga Ah ee Nofosibirsik",
               "",
               "Waqtiga Xagaaga ee Nofosibirsik",
               "",
               "Waqtiga Nofosibirsik",
               "",
            };
        final String[] Philippines = new String[] {
               "Waqtiga Caadiga Ah ee Filibiin",
               "PST",
               "Waqtiga Xagaaga ee Filibiin",
               "PDT",
               "Waqtiga Filibiin",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Waqtiga Caadiga Ah ee Faladifostok",
               "",
               "Waqtiga Xagaaga ee Faladifostok",
               "",
               "Waqtiga Faladifostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Waqtiga Badweynta Hindiya",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Waqtiga Leyn Aylaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Waqtiga Caadiga Ah ee Niyuufoonlaan",
               "NST",
               "Waqtiga Dharaarta ee Niyuufoonlaan",
               "NDT",
               "Waqtiga Niyuufoonlaan",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Waqtiga Caadiga Ah ee Turkmenistan",
               "",
               "Waqtiga Xagaaga ee Turkmenistan",
               "",
               "Waqtiga Turkmenistaan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Waqtiga Ferenj Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Waqtiga Caadiga Ah ee Niyuu Kaledoniya",
               "",
               "Waqtiga Xagaaga ee Niyuu Kaledoniya",
               "",
               "Waqtiga Niyuu Kaledonya",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Waqtiga Sowt Joorjiya",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Waqtiga Caadiga Ah ee Yekaterinbaag",
               "",
               "Waqtiga Xagaaga ee Yekaterinbaag",
               "",
               "Waqtiga Yekaterinbaag",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Waqtiga Bartamaha Afrika",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Waqtiga Bariga Afrika",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Waqtiga Caadiga Ah ee Galbeedka Afrika",
               "WAT",
               "Waqtiga Xagaaga ee Galbeedka Afrika",
               "WAT",
               "Waqtiga Galbeedka Afrika",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Waqtiga Dumont - d\u2019urfille",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Waqtiga Caadiga Ah ee Bartamaha Yurub",
               "CET",
               "Waqtiga Xagaaga ee Bartamaha Yurub",
               "CEST",
               "Waqtiga Bartamaha Yurub",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Waqtiga Caadiga Ah ee Bariga Yurub",
               "EET",
               "Waqtiga Xagaaga ee Bariga Yurub",
               "EEST",
               "Waqtiga Bariga Yurub",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Waqtiga Caadiga Ah ee Galbeedka Yurub",
               "WET",
               "Waqtiga Xagaaga ee Galbeedka Yurub",
               "WEST",
               "Waqtiga Galbeedka Yurub",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Waqtiga Caadiga Ah ee Baasifikada Meksiko",
               "MST",
               "Waqtiga Dharaarta ee Baasifikada Meksiko",
               "MDT",
               "Waqtiga Baasifikada Meksiko",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Waqtiyada Caadiga Ah ee Koonfur Afrika",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Waqtiga Caadiga Ah ee Bartamaha Waqooyiga Ameerika",
               "CST",
               "Waqtiga Dharaarta ee Bartamaha Waqooyiga Ameerika",
               "CDT",
               "Waqtiga Bartamaha Waqooyiga Ameerika",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Waqtiga Caadiga Ah ee Bariga Waqooyiga Ameerika",
               "EST",
               "Waqtiga Dharaarta ee Bariga Waqooyiga Ameerika",
               "EST",
               "Waqtiga Bariga ee Waqooyiga Ameerika",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Waqtiga Caadiga ah ee Basifika Waqooyiga Ameerika",
               "PST",
               "Waqtiga Dharaarta ee Basifika Waqooyiga Ameerika",
               "PDT",
               "Waqtiga Basifika ee Waqooyiga Ameerika",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Waqtiga Koonfurta Faransiiska & Antaarktik",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Waqtiga Jilbeert Aylaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Waqtiga Caadiga Ah ee Hawaay-Alutiyaan",
               "HAST",
               "Waqtiga Dharaarta ee Hawaay-Alutiyaan",
               "HADT",
               "Waqtiga Hawaay-Alutiyaan",
               "HAT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Waqtiga Foonikis Aylaanis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Waqtiga Caadiga Ah St. Beere & Mikiwelon",
               "",
               "Waqtiga Dharaarta ee St. Beere & Mikiwelon",
               "",
               "Waqtiga St. Beere & Mikiwelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Waqtiga Caadiga ah ee Buuraleyda Waqooyiga Ameerika",
               "MST",
               "Waqtiga Dharaarta ee Buurleyda Waqooyiga Ameerika",
               "MST",
               "Waqtiga Buuraleyda ee Waqooyiga Ameerika",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Waqtiga Maarshaal Aylaanis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Waqtiga Babuw Niyuu Giniya",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Waqtiga Caadiga Ah ee Bartamaha Astaraaliya",
               "ACST",
               "Waqtiga Dharaarta ee Bartamaha Astaraaliya",
               "ACDT",
               "Waqtiga Bartamaha Astaraaliya",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Waqtiyada Caadiga ah ee Bariga Astaraaliya",
               "AEST",
               "Waqtiga Dharaarta ee Bariga Astaraaliya",
               "AEDT",
               "Waqtiga Bariga Astaraaliya",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Waqtiga Caadiga Ah ee Galbeedka Astaraaliya",
               "AWST",
               "Waqtiga Dharaarta ee Galbeedka Astaraaliya",
               "AWDT",
               "Waqtiga Galbeedka Astaraaliya",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Waqtiga Bartamaha Indoneeysiya",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Waqtiga Indoneeysiya",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Waqtiga Galbeedka Indoneeysiya",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Waqtiga Koonfurta Kasakhistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Waqtiga Caadiga Ah ee Bartamaha Galbeedka Astaraaliya",
               "",
               "Waqtiga Dharaarta Bartamaha Galbeedka Australiya",
               "",
               "Waqtiga Bartamaha Galbeedka Astaraaliya",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Wakhtiga Giriinwij",
                    "GMT",
                    "Waqtiga Xagaaga ee Biritishka",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Waqtiga Isku-xiran ee Caalamka",
                    "Waqtiga UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Wakhtiga Giriinwij",
                    "GMT",
                    "Waqtiga Caadiga Ah ee Ayrishka",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Waqtiga Isku-xiran ee Caalamka",
                    "Waqtiga UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Waqtiga Isku-xiran ee Caalamka",
                    "Waqtiga UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Wakhtiga Giriinwij",
                    "GMT",
                    "Waqtiga Xagaaga ee Biritishka",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Waqtiga Isku-xiran ee Caalamka",
                    "Waqtiga UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Waqtiga Isku-xiran ee Caalamka",
                    "Waqtiga UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Western },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Western },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Waqtiga Isku-xiran ee Caalamka",
                    "Waqtiga UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Wakhtiga Giriinwij",
                    "GMT",
                    "Waqtiga Caadiga Ah ee Ayrishka",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Wakhtiga Giriinwij",
                    "GMT",
                    "Waqtiga Xagaaga ee Biritishka",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Wakhtiga Giriinwij",
                    "GMT",
                    "Waqtiga Xagaaga ee Biritishka",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Wakhtiga Giriinwij",
                    "GMT",
                    "Waqtiga Xagaaga ee Biritishka",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Wakhtiga Giriinwij",
                    "GMT",
                    "Waqtiga Xagaaga ee Biritishka",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Wakhtiga Giriinwij",
                    "GMT",
                    "Waqtiga Xagaaga ee Biritishka",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Cadan" },
            { "timezone.excity.Asia/Gaza", "Qasa" },
            { "timezone.excity.Asia/Hovd", "Hofud" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Ammaan" },
            { "timezone.excity.Asia/Aqtau", "Aktaw" },
            { "timezone.excity.Asia/Chita", "Jiita" },
            { "timezone.excity.Asia/Dhaka", "Dhaaka" },
            { "timezone.excity.Asia/Dubai", "Dubay" },
            { "timezone.excity.Asia/Kabul", "Kaabuul" },
            { "timezone.excity.Asia/Macau", "Makow" },
            { "timezone.excity.Asia/Qatar", "Qaddar" },
            { "timezone.excity.Asia/Seoul", "Soul" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Loom" },
            { "timezone.excity.Asia/Almaty", "Almati" },
            { "timezone.excity.Asia/Anadyr", "Anadiyr" },
            { "timezone.excity.Asia/Atyrau", "Atiyraw" },
            { "timezone.excity.Asia/Beirut", "Beyruud" },
            { "timezone.excity.Asia/Brunei", "Buruney" },
            { "timezone.excity.Asia/Kuwait", "Kuweyt" },
            { "timezone.excity.Asia/Manila", "Maniila" },
            { "timezone.excity.Asia/Muscat", "Muskat" },
            { "timezone.excity.Asia/Riyadh", "Riyaad" },
            { "timezone.excity.Asia/Saigon", "Hoo Ji Mih Siti" },
            { "timezone.excity.Asia/Taipei", "Teybey" },
            { "timezone.excity.Asia/Tehran", "Tehraan" },
            { "timezone.excity.Etc/Unknown", "Magaalo Aan La Garanayn" },
            { "timezone.excity.Europe/Kiev", "Kiyeef" },
            { "timezone.excity.Europe/Riga", "Riija" },
            { "timezone.excity.Europe/Rome", "Rooma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akra" },
            { "timezone.excity.Africa/Cairo", "Qaahira" },
            { "timezone.excity.Africa/Ceuta", "Seuta" },
            { "timezone.excity.Africa/Lagos", "Laagoos" },
            { "timezone.excity.Africa/Tunis", "Tuunis" },
            { "timezone.excity.America/Lima", "Liima" },
            { "timezone.excity.America/Nome", "Noom" },
            { "timezone.excity.Asia/Baghdad", "Baqdaad" },
            { "timezone.excity.Asia/Bahrain", "Baxreyn" },
            { "timezone.excity.Asia/Bangkok", "Bangkook" },
            { "timezone.excity.Asia/Barnaul", "Barnaauul" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Irkutsk", "Irkutsik" },
            { "timezone.excity.Asia/Jakarta", "Jakaarta" },
            { "timezone.excity.Asia/Karachi", "Karaaji" },
            { "timezone.excity.Asia/Kuching", "Kujing" },
            { "timezone.excity.Asia/Magadan", "Magedan" },
            { "timezone.excity.Asia/Nicosia", "Nikosiya" },
            { "timezone.excity.Asia/Tbilisi", "Tibilisi" },
            { "timezone.excity.Asia/Thimphu", "Timbu" },
            { "timezone.excity.Asia/Yakutsk", "Yakut" },
            { "timezone.excity.Asia/Yerevan", "Yerefan" },
            { "timezone.excity.Europe/Kirov", "Kiroof" },
            { "timezone.excity.Europe/Minsk", "Minisk" },
            { "timezone.excity.Europe/Paris", "Baariis" },
            { "timezone.excity.Europe/Sofia", "Sofiya" },
            { "timezone.excity.Europe/Vaduz", "Faduus" },
            { "timezone.excity.Indian/Cocos", "Kokos" },
            { "timezone.excity.Pacific/Apia", "Abiya" },
            { "timezone.excity.Pacific/Guam", "Guwam" },
            { "timezone.excity.Pacific/Niue", "Niyuu" },
            { "timezone.excity.Pacific/Truk", "Juuk" },
            { "timezone.excity.Africa/Bamako", "Bamaako" },
            { "timezone.excity.Africa/Bangui", "Baagi" },
            { "timezone.excity.Africa/Bissau", "Bisaaw" },
            { "timezone.excity.Africa/Douala", "Douaala" },
            { "timezone.excity.Africa/Harare", "Haraare" },
            { "timezone.excity.Africa/Luanda", "Luwaanda" },
            { "timezone.excity.Africa/Lusaka", "Lusaaka" },
            { "timezone.excity.Africa/Maputo", "Mabuuto" },
            { "timezone.excity.Africa/Maseru", "Maseero" },
            { "timezone.excity.Africa/Niamey", "Nijame" },
            { "timezone.excity.America/Bahia", "Baahiya" },
            { "timezone.excity.America/Boise", "Boyse" },
            { "timezone.excity.America/Sitka", "Siitka" },
            { "timezone.excity.America/Thule", "Tuul" },
            { "timezone.excity.Asia/Calcutta", "Kolkaata" },
            { "timezone.excity.Asia/Damascus", "Dimishiq" },
            { "timezone.excity.Asia/Jayapura", "Jayabura" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Khandyga", "Khandiyga" },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "timezone.excity.Asia/Shanghai", "Shanghaay" },
            { "timezone.excity.Asia/Tashkent", "Toshkeent" },
            { "timezone.excity.Europe/Athens", "Atens" },
            { "timezone.excity.Europe/Berlin", "Barliin" },
            { "timezone.excity.Europe/Dublin", "Dhaablin" },
            { "timezone.excity.Europe/Jersey", "Jaarsey" },
            { "timezone.excity.Europe/London", "Landan" },
            { "timezone.excity.Europe/Madrid", "Madriid" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskow" },
            { "timezone.excity.Europe/Prague", "Baraag" },
            { "timezone.excity.Europe/Skopje", "Iskoobje" },
            { "timezone.excity.Europe/Tirane", "Tiraane" },
            { "timezone.excity.Europe/Vienna", "Fiyeena" },
            { "timezone.excity.Europe/Zagreb", "Saqrib" },
            { "timezone.excity.Europe/Zurich", "Suurikh" },
            { "timezone.excity.Indian/Chagos", "Jagos" },
            { "timezone.excity.Indian/Comoro", "Komoro" },
            { "timezone.excity.Pacific/Nauru", "Nawroo" },
            { "timezone.excity.Pacific/Palau", "Balaw" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abidjaan" },
            { "timezone.excity.Africa/Algiers", "Aljeeris" },
            { "timezone.excity.Africa/Conakry", "Conakri" },
            { "timezone.excity.Africa/Kampala", "Kambaala" },
            { "timezone.excity.Africa/Mbabane", "Mababaane" },
            { "timezone.excity.Africa/Nairobi", "Nayroobi" },
            { "timezone.excity.Africa/Tripoli", "Tiribooli" },
            { "timezone.excity.America/Belize", "Beliise" },
            { "timezone.excity.America/Cancun", "Kaankuun" },
            { "timezone.excity.America/Cayman", "Keymaan" },
            { "timezone.excity.America/Cuiaba", "Kuyaaba" },
            { "timezone.excity.America/Dawson", "Doosan" },
            { "timezone.excity.America/Denver", "Denfar" },
            { "timezone.excity.America/Guyana", "Guyaana" },
            { "timezone.excity.America/Havana", "Hafaana" },
            { "timezone.excity.America/Inuvik", "Inuufik" },
            { "timezone.excity.America/Juneau", "Juniyuu" },
            { "timezone.excity.America/La_Paz", "Laa Baas" },
            { "timezone.excity.America/Maceio", "Maasiiyo" },
            { "timezone.excity.America/Manaus", "Manaauus" },
            { "timezone.excity.America/Merida", "Meriida" },
            { "timezone.excity.America/Nassau", "Nasaaw" },
            { "timezone.excity.America/Panama", "Banaama" },
            { "timezone.excity.America/Recife", "Receyf" },
            { "timezone.excity.America/Regina", "Rejiina" },
            { "timezone.excity.Asia/Hong_Kong", "Hoong Koong" },
            { "timezone.excity.Asia/Jerusalem", "Jeerusaalem" },
            { "timezone.excity.Asia/Kamchatka", "Kamkatka" },
            { "timezone.excity.Asia/Pontianak", "Botiyaanak" },
            { "timezone.excity.Asia/Pyongyang", "Boyongyang" },
            { "timezone.excity.Asia/Qyzylorda", "Qiyslorda" },
            { "timezone.excity.Asia/Samarkand", "Samarkaan" },
            { "timezone.excity.Asia/Singapore", "Singabuur" },
            { "timezone.excity.Asia/Vientiane", "Fiyaantiyaan" },
            { "timezone.excity.Europe/Andorra", "Andoora" },
            { "timezone.excity.Europe/Saratov", "Saratoof" },
            { "timezone.excity.Europe/Tallinn", "Taalin" },
            { "timezone.excity.Europe/Vatican", "Fatikaan" },
            { "timezone.excity.Europe/Vilnius", "Finiyuus" },
            { "timezone.excity.Indian/Mayotte", "Mayoote" },
            { "timezone.excity.Indian/Reunion", "Riyuuniyon" },
            { "timezone.excity.Pacific/Easter", "Iistar" },
            { "timezone.excity.Pacific/Kanton", "Kantoon" },
            { "timezone.excity.Pacific/Kosrae", "Kosrii" },
            { "timezone.excity.Pacific/Majuro", "Majro" },
            { "timezone.excity.Pacific/Noumea", "Noomiya" },
            { "timezone.excity.Pacific/Ponape", "Bonbey" },
            { "timezone.excity.Pacific/Saipan", "Seyban" },
            { "timezone.excity.Pacific/Wallis", "Walis" },
            { "timezone.excity.Africa/Blantyre", "Balantire" },
            { "timezone.excity.Africa/Djibouti", "Jibuuti" },
            { "timezone.excity.Africa/El_Aaiun", "El Ceyuun" },
            { "timezone.excity.Africa/Freetown", "Firiitawn" },
            { "timezone.excity.Africa/Gaborone", "Gabroon" },
            { "timezone.excity.Africa/Khartoum", "Khartuum" },
            { "timezone.excity.Africa/Monrovia", "Monrofiya" },
            { "timezone.excity.Africa/Ndjamena", "Injamina" },
            { "timezone.excity.Africa/Sao_Tome", "Saw Toom" },
            { "timezone.excity.Africa/Windhoek", "Windhook" },
            { "timezone.excity.America/Antigua", "Antiguwa" },
            { "timezone.excity.America/Caracas", "Karakaas" },
            { "timezone.excity.America/Cayenne", "Kayeen" },
            { "timezone.excity.America/Chicago", "Jikaago" },
            { "timezone.excity.America/Cordoba", "Kordooba" },
            { "timezone.excity.America/Creston", "Karestoon" },
            { "timezone.excity.America/Curacao", "Kurakoow" },
            { "timezone.excity.America/Detroit", "Detoroyt" },
            { "timezone.excity.America/Grenada", "Garenaada" },
            { "timezone.excity.America/Halifax", "Halifakas" },
            { "timezone.excity.America/Iqaluit", "Iqaaluut" },
            { "timezone.excity.America/Jamaica", "Jamayka" },
            { "timezone.excity.America/Managua", "Manaaguwa" },
            { "timezone.excity.America/Marigot", "Maarigot" },
            { "timezone.excity.America/Mendoza", "Meendoosa" },
            { "timezone.excity.America/Moncton", "Moonktoon" },
            { "timezone.excity.America/Ojinaga", "Ojinaaga" },
            { "timezone.excity.America/Phoenix", "Foonikis" },
            { "timezone.excity.America/Tijuana", "Tijuwaana" },
            { "timezone.excity.America/Tortola", "Tortoola" },
            { "timezone.excity.America/Yakutat", "Yakutaat" },
            { "timezone.excity.Asia/Choibalsan", "Joybalsan" },
            { "timezone.excity.Asia/Phnom_Penh", "Benom Ben" },
            { "timezone.excity.Atlantic/Azores", "Asores" },
            { "timezone.excity.Atlantic/Canary", "Kanari" },
            { "timezone.excity.Atlantic/Faeroe", "Farow" },
            { "timezone.excity.Australia/Eucla", "Yukla" },
            { "timezone.excity.Australia/Perth", "Bert" },
            { "timezone.excity.Europe/Belgrade", "Belgaraydh" },
            { "timezone.excity.Europe/Brussels", "Barasalis" },
            { "timezone.excity.Europe/Budapest", "Budabest" },
            { "timezone.excity.Europe/Busingen", "Busingeen" },
            { "timezone.excity.Europe/Chisinau", "Jisinaaw" },
            { "timezone.excity.Europe/Guernsey", "Geernisi" },
            { "timezone.excity.Europe/Helsinki", "Heleniski" },
            { "timezone.excity.Europe/Istanbul", "Istanbuul" },
            { "timezone.excity.Europe/Sarajevo", "Sarayeefo" },
            { "timezone.excity.Indian/Maldives", "Maldifis" },
            { "timezone.excity.Pacific/Chatham", "Jatam" },
            { "timezone.excity.Pacific/Fakaofo", "fakofo" },
            { "timezone.excity.Pacific/Gambier", "Gambiyr" },
            { "timezone.excity.Pacific/Norfolk", "Noorfek" },
            { "timezone.excity.Africa/Mogadishu", "Muqdisho" },
            { "timezone.excity.America/Anguilla", "Anguwila" },
            { "timezone.excity.America/Asuncion", "Asunkiyon" },
            { "timezone.excity.America/Dominica", "Dominiika" },
            { "timezone.excity.America/Eirunepe", "Iiruneeb" },
            { "timezone.excity.America/Mazatlan", "Mazaatlan" },
            { "timezone.excity.America/Miquelon", "Miiquulon" },
            { "timezone.excity.America/New_York", "Niyuu Yook" },
            { "timezone.excity.America/Resolute", "Resoluut" },
            { "timezone.excity.America/Santarem", "Santareem" },
            { "timezone.excity.America/Santiago", "Santiyaago" },
            { "timezone.excity.America/St_Johns", "St. Joon" },
            { "timezone.excity.America/St_Kitts", "St. Kitis" },
            { "timezone.excity.America/St_Lucia", "St. Lusiya" },
            { "timezone.excity.America/Winnipeg", "Winibeg" },
            { "timezone.excity.Antarctica/Casey", "Kaysee" },
            { "timezone.excity.Antarctica/Davis", "Dafis" },
            { "timezone.excity.Antarctica/Syowa", "Siyowa" },
            { "timezone.excity.Antarctica/Troll", "Torool" },
            { "timezone.excity.Asia/Krasnoyarsk", "Karasnoyarska" },
            { "timezone.excity.Asia/Novosibirsk", "Nofosibirsik" },
            { "timezone.excity.Asia/Vladivostok", "Faladifostok" },
            { "timezone.excity.Atlantic/Bermuda", "Barmuuda" },
            { "timezone.excity.Atlantic/Madeira", "Madira" },
            { "timezone.excity.Atlantic/Stanley", "Istaanley" },
            { "timezone.excity.Australia/Hobart", "Hubaart" },
            { "timezone.excity.Australia/Sydney", "Sidney" },
            { "timezone.excity.Europe/Amsterdam", "Amsterdaam" },
            { "timezone.excity.Europe/Astrakhan", "Astarakhaan" },
            { "timezone.excity.Europe/Bucharest", "Bujarest" },
            { "timezone.excity.Europe/Ljubljana", "Lubalaana" },
            { "timezone.excity.Europe/Mariehamn", "Maarihaam" },
            { "timezone.excity.Europe/Podgorica", "Bodgorika" },
            { "timezone.excity.Europe/Stockholm", "Istokhoom" },
            { "timezone.excity.Europe/Ulyanovsk", "Ulyanofisk" },
            { "timezone.excity.Europe/Volgograd", "Folgograd" },
            { "timezone.excity.Indian/Christmas", "Kiristmas" },
            { "timezone.excity.Indian/Kerguelen", "Kergalen" },
            { "timezone.excity.Indian/Mauritius", "Morishiyaas" },
            { "timezone.excity.Pacific/Auckland", "Owklaan" },
            { "timezone.excity.Pacific/Pitcairn", "Bitkayrn" },
            { "timezone.excity.Africa/Casablanca", "Kasabalaanka" },
            { "timezone.excity.Africa/Libreville", "Librefil" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbaashi" },
            { "timezone.excity.Africa/Nouakchott", "Nookjot" },
            { "timezone.excity.Africa/Porto-Novo", "Boorto-Noofo" },
            { "timezone.excity.America/Anchorage", "Anjorage" },
            { "timezone.excity.America/Araguaina", "Araguwayna" },
            { "timezone.excity.America/Boa_Vista", "Bow Fista" },
            { "timezone.excity.America/Catamarca", "Katamaarka" },
            { "timezone.excity.America/Chihuahua", "Jiwaahuu" },
            { "timezone.excity.America/Fortaleza", "Footalesa" },
            { "timezone.excity.America/Glace_Bay", "Galeys Baay" },
            { "timezone.excity.America/Goose_Bay", "Guus Baay" },
            { "timezone.excity.America/Guatemala", "Guwatemaala" },
            { "timezone.excity.America/Guayaquil", "Guwayaquwil" },
            { "timezone.excity.America/Menominee", "Menoominee" },
            { "timezone.excity.America/Monterrey", "Moonteerey" },
            { "timezone.excity.America/Sao_Paulo", "Saaw Boolo" },
            { "timezone.excity.America/St_Thomas", "St. Toomas" },
            { "timezone.excity.America/Vancouver", "Fankuufar" },
            { "timezone.excity.Antarctica/Palmer", "Baamar" },
            { "timezone.excity.Antarctica/Vostok", "Fostok" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lambuur" },
            { "timezone.excity.Asia/Novokuznetsk", "Nofokusnetsik" },
            { "timezone.excity.Europe/Bratislava", "Baratislafa" },
            { "timezone.excity.Europe/Copenhagen", "Kobenhaagan" },
            { "timezone.excity.Europe/Luxembourg", "Luksemberg" },
            { "timezone.excity.Europe/San_Marino", "San Mariino" },
            { "timezone.excity.Europe/Simferopol", "Simferobol" },
            { "timezone.excity.Pacific/Enderbury", "Enderburi" },
            { "timezone.excity.Pacific/Galapagos", "Galabagos" },
            { "timezone.excity.Pacific/Kwajalein", "Kuwajaleyn" },
            { "timezone.excity.Pacific/Marquesas", "Marquwesas" },
            { "timezone.excity.Pacific/Pago_Pago", "Bago Bago" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatabu" },
            { "timezone.excity.Africa/Brazzaville", "Barasafil" },
            { "timezone.excity.Africa/Ouagadougou", "Wagadugu" },
            { "timezone.excity.America/Costa_Rica", "Kosta Riika" },
            { "timezone.excity.America/Grand_Turk", "Garaan Turk" },
            { "timezone.excity.America/Guadeloupe", "Guwadeluub" },
            { "timezone.excity.America/Hermosillo", "Harmosilo" },
            { "timezone.excity.America/Kralendijk", "Kiraalendik" },
            { "timezone.excity.America/Louisville", "Luusfile" },
            { "timezone.excity.America/Martinique", "Maartiniikuyuu" },
            { "timezone.excity.America/Metlakatla", "Metlaakatla" },
            { "timezone.excity.America/Montevideo", "Moontafiidiyo" },
            { "timezone.excity.America/Montserrat", "Moontseraat" },
            { "timezone.excity.America/Rio_Branco", "Riyo Baraanko" },
            { "timezone.excity.America/St_Vincent", "St. Finsent" },
            { "timezone.excity.America/Whitehorse", "Waythoras" },
            { "timezone.excity.Antarctica/McMurdo", "MakMurdo" },
            { "timezone.excity.Antarctica/Rothera", "Rotera" },
            { "timezone.excity.Asia/Srednekolymsk", "Sarednokoleymisk" },
            { "timezone.excity.Asia/Yekaterinburg", "Yekaterinbaag" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjafik" },
            { "timezone.excity.Australia/Adelaide", "Adelayde" },
            { "timezone.excity.Australia/Brisbane", "Birisban" },
            { "timezone.excity.Europe/Isle_of_Man", "Ayle of Maan" },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimaati" },
            { "timezone.excity.Africa/Johannesburg", "Johansbaag" },
            { "timezone.excity.America/El_Salvador", "El Salfadoor" },
            { "timezone.excity.America/Fort_Nelson", "Foot Nelson" },
            { "timezone.excity.America/Los_Angeles", "Loos Anjalis" },
            { "timezone.excity.America/Mexico_City", "Meksiko Siti" },
            { "timezone.excity.America/Puerto_Rico", "Boorta Riiko" },
            { "timezone.excity.America/Tegucigalpa", "Tegusigalba" },
            { "timezone.excity.Arctic/Longyearbyen", "Lonjirbyeen" },
            { "timezone.excity.Atlantic/Cape_Verde", "Keyb Faarde" },
            { "timezone.excity.Australia/Lord_Howe", "Lod How" },
            { "timezone.excity.Australia/Melbourne", "Melboon" },
            { "timezone.excity.Indian/Antananarivo", "Antananarifo" },
            { "timezone.excity.Pacific/Guadalcanal", "Cuadalkanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Daresalaam" },
            { "timezone.excity.America/Blanc-Sablon", "Balank-Sablon" },
            { "timezone.excity.America/Buenos_Aires", "Buwenos Ayris" },
            { "timezone.excity.America/Campo_Grande", "Kaambo Garandi" },
            { "timezone.excity.America/Danmarkshavn", "Daanmaakshaan" },
            { "timezone.excity.America/Dawson_Creek", "Doosan Kireek" },
            { "timezone.excity.America/Indiana/Knox", "Nokis, Indiyaana" },
            { "timezone.excity.America/Indianapolis", "Indiyaanabolis" },
            { "timezone.excity.America/Punta_Arenas", "Bunta Arinaas" },
            { "timezone.excity.America/Rankin_Inlet", "Raankin Inleet" },
            { "timezone.excity.America/Scoresbysund", "Itoqortoomiit" },
            { "timezone.excity.Antarctica/Macquarie", "Makquwariy" },
            { "timezone.excity.Pacific/Bougainville", "Boogaynfil" },
            { "timezone.excity.Pacific/Port_Moresby", "Boort Moresbi" },
            { "timezone.excity.America/Cambridge_Bay", "Kambiriij Baay" },
            { "timezone.excity.America/Ciudad_Juarez", "Magaalada Juarez" },
            { "timezone.excity.America/Coral_Harbour", "Atikokaan" },
            { "timezone.excity.America/Indiana/Vevay", "Feefaay, Indiyaana" },
            { "timezone.excity.America/Lower_Princes", "Loowa Birinses Kuwaata" },
            { "timezone.excity.America/Port_of_Spain", "Boort of Isbayn" },
            { "timezone.excity.America/Santo_Domingo", "Saanto Domingo" },
            { "timezone.excity.America/St_Barthelemy", "St. Baartelemi" },
            { "timezone.excity.America/Swift_Current", "Iswift Karent" },
            { "timezone.excity.Australia/Broken_Hill", "Boroken Hil" },
            { "timezone.excity.America/Bahia_Banderas", "Bahiya Banderas" },
            { "timezone.excity.America/Port-au-Prince", "Boort-aw-Biriins" },
            { "timezone.excity.Atlantic/South_Georgia", "Sowt Joorjiya" },
            { "timezone.excity.America/Indiana/Marengo", "Mareengo, Indiyaana" },
            { "timezone.excity.America/Indiana/Winamac", "Winaamak, Indiyaana" },
            { "timezone.excity.America/Argentina/Tucuman", "Tukuumaan" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaay" },
            { "timezone.excity.America/Indiana/Tell_City", "Tel Siti, Indiyaana" },
            { "timezone.excity.America/Indiana/Vincennes", "Finseenes, Indiyaana" },
            { "timezone.excity.Antarctica/DumontDUrville", "Dumont d\u2019urfile" },
            { "timezone.excity.America/Argentina/La_Rioja", "La Riyoja" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juwaan" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luwis" },
            { "timezone.excity.America/Indiana/Petersburg", "Betesbaag, Indiyaana" },
            { "timezone.excity.America/Kentucky/Monticello", "Montiseelo, Kentaki" },
            { "timezone.excity.America/North_Dakota/Beulah", "Biyuulah, Waqooyiga Dakoota" },
            { "timezone.excity.America/North_Dakota/Center", "Bartamaha, Waqooyiga Dakoota" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Riyo Jalejos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Niyuu Saalem, Waqooyiga Dakoota" },
        };
        return data;
    }
}
